<?php declare(strict_types=1);
/**
 * This file is part of Swoft.
 *
 * @link     https://swoft.org
 * @document https://swoft.org/docs
 * @contact  group@swoft.org
 * @license  https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace MSwoft\WebSocket\Server\MessageParser;

use MSwoft\Bean\Annotation\Mapping\Bean;
use MSwoft\WebSocket\Server\Contract\MessageParserInterface;
use MSwoft\WebSocket\Server\Message\Message;

/**
 * Class TextParser
 *
 * @since 2.0
 * @Bean()
 */
class RawTextParser implements MessageParserInterface
{
    /**
     * Encode Message data to string.
     *
     * @param Message $message
     *
     * @return string
     */
    public function encode(Message $message): string
    {
        return $message->getDataString();
    }

    /**
     * Decode data to Message.
     *
     * @param string $data
     *
     * @return Message
     */
    public function decode(string $data): Message
    {
        return Message::new('', $data);
    }
}
