<?php declare(strict_types=1);
/**
 * This file is part of Swoft.
 *
 * @link     https://swoft.org
 * @document https://swoft.org/docs
 * @contact  group@swoft.org
 * @license  https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace MSwoft\WebSocket\Server\MessageParser;

use MSwoft\Bean\Annotation\Mapping\Bean;
use MSwoft\Stdlib\Helper\JsonHelper;
use MSwoft\WebSocket\Server\Contract\MessageParserInterface;
use MSwoft\WebSocket\Server\Message\Message;

/**
 * Class JsonParser
 *
 * @since 2.0
 * @Bean()
 */
class JsonParser implements MessageParserInterface
{
    /**
     * @param Message $message
     *
     * @return string
     */
    public function encode(Message $message): string
    {
        return JsonHelper::encode($message->toArray());
    }

    /**
     * Decode data to array.
     *
     * @param string $data Message data. It's {@see \Swoole\WebSocket\Frame::$data)
     *
     * @return Message
     */
    public function decode(string $data): Message
    {
        $map = JsonHelper::decode($data, true);

        return Message::newFromArray($map);
    }
}
