<?php declare(strict_types=1);
/**
 * This file is part of Swoft.
 *
 * @link     https://swoft.org
 * @document https://swoft.org/docs
 * @contact  group@swoft.org
 * @license  https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace MSwoft\WebSocket\Server\Message\Middleware;

use MSwoft\Bean\Annotation\Mapping\Bean;
use MSwoft\WebSocket\Server\Contract\MessageHandlerInterface;
use MSwoft\WebSocket\Server\Contract\MiddlewareInterface;
use MSwoft\WebSocket\Server\Contract\RequestInterface;
use MSwoft\WebSocket\Server\Contract\ResponseInterface;

/**
 * Class DefaultMiddleware
 *
 * @since 2.0
 *
 * @Bean()
 */
class DefaultMiddleware implements MiddlewareInterface
{
    /**
     * @param RequestInterface        $request
     * @param MessageHandlerInterface $handler
     *
     * @return ResponseInterface
     */
    public function process(RequestInterface $request, MessageHandlerInterface $handler): ResponseInterface
    {
        return $handler->handle($request);
    }
}
