<?php declare(strict_types=1);
/**
 * This file is part of Swoft.
 *
 * @link     https://swoft.org
 * @document https://swoft.org/docs
 * @contact  group@swoft.org
 * @license  https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace MSwoft\WebSocket\Server\Listener;

use Swoft;
use MSwoft\Event\Annotation\Mapping\Listener;
use MSwoft\Event\EventHandlerInterface;
use MSwoft\Event\EventInterface;
use MSwoft\Log\Helper\CLog;
use MSwoft\SwoftEvent;
use MSwoft\WebSocket\Server\Router\Router;
use MSwoft\WebSocket\Server\Router\RouteRegister;
use MSwoft\WebSocket\Server\WsServerBean;

/**
 * Class AppInitCompleteListener
 *
 * @since 2.0
 *
 * @Listener(SwoftEvent::APP_INIT_COMPLETE)
 */
class AppInitCompleteListener implements EventHandlerInterface
{
    /**
     * @param EventInterface $event
     */
    public function handle(EventInterface $event): void
    {
        // Register webSocket routes

        /** @var Router $router */
        $router = Swoft::getSingleton(WsServerBean::ROUTER);

        RouteRegister::registerTo($router);

        CLog::info('WebSocket server route registered(module %d, message command %d)', $router->getModuleCount(), $router->getCounter());
    }
}
