<?php declare(strict_types=1);
/**
 * This file is part of Swoft.
 *
 * @link     https://swoft.org
 * @document https://swoft.org/docs
 * @contact  group@swoft.org
 * @license  https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace MSwoft\WebSocket\Server\Contract;

use MSwoft\Error\Contract\ErrorHandlerInterface;
use MSwoft\Http\Message\Request;
use Throwable;

/**
 * Interface OpenErrorHandlerInterface
 *
 * @since 2.0
 */
interface OpenErrorHandlerInterface extends ErrorHandlerInterface
{
    /**
     * @param Throwable $e
     * @param Request   $request
     *
     * @return void
     */
    public function handle(Throwable $e, Request $request): void;
}
