<?php declare(strict_types=1);
/**
 * This file is part of Swoft.
 *
 * @link     https://swoft.org
 * @document https://swoft.org/docs
 * @contact  group@swoft.org
 * @license  https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace MSwoft\WebSocket\Server\Contract;

use MSwoft\WebSocket\Server\Message\Request;
use MSwoft\WebSocket\Server\Message\Response;

/**
 * Interface MiddlewareInterface
 *
 * @since 2.0
 */
interface MiddlewareInterface
{
    /**
     * @param RequestInterface|Request        $request
     * @param MessageHandlerInterface $handler
     *
     * @return ResponseInterface|Response
     */
    public function process(RequestInterface $request, MessageHandlerInterface $handler): ResponseInterface;
}
