<?php declare(strict_types=1);

namespace MSwoft\Validator\Rule;

use MSwoft\Bean\Annotation\Mapping\Bean;
use MSwoft\Validator\Annotation\Mapping\Upper;
use MSwoft\Validator\Contract\RuleInterface;
use MSwoft\Validator\Exception\ValidatorException;

/**
 * Class UpperRule
 *
 * @since 2.0
 *
 * @Bean(Upper::class)
 */
class UpperRule implements RuleInterface
{
    /**
     * @param array  $data
     * @param string $propertyName
     * @param object $item
     * @param null   $default
     *
     * @return array
     * @throws ValidatorException
     */
    public function validate(array $data, string $propertyName, $item, $default = null, $strict = false): array
    {
        $value = $data[$propertyName];
        $rule  = '/^[A-Z]+$/';
        if (preg_match($rule, $value)) {
            return $data;
        }

        /* @var Upper $item */
        $message = $item->getMessage();
        $message = (empty($message)) ? sprintf('%s must be uppercase alpha', $propertyName) : $message;

        throw new ValidatorException($message);
    }
}
