<?php declare(strict_types=1);


namespace MSwoft\Validator\Rule;


use MSwoft\Bean\Annotation\Mapping\Bean;
use MSwoft\Validator\Annotation\Mapping\Pattern;
use MSwoft\Validator\Contract\RuleInterface;
use MSwoft\Validator\Exception\ValidatorException;
use MSwoft\Validator\Helper\ValidatorHelper;

/**
 * Class PatternRule
 *
 * @since 2.0
 *
 * @Bean(Pattern::class)
 */
class PatternRule implements RuleInterface
{
    /**
     * @param array      $data
     * @param string     $propertyName
     * @param object     $item
     * @param mixed|null $default
     *
     * @return array
     * @throws ValidatorException
     */
    public function validate(array $data, string $propertyName, $item, $default = null, $strict = false): array
    {
        /* @var Pattern $item */
        $regex = $item->getRegex();
        $value = $data[$propertyName];
        if (ValidatorHelper::validatePattern($value, $regex)) {
            return $data;
        }

        $message = $item->getMessage();
        $message = (empty($message)) ? sprintf('%s is invalid pattern!', $propertyName) : $message;
        throw new ValidatorException($message);
    }
}
