<?php declare(strict_types=1);


namespace MSwoft\Validator\Rule;


use MSwoft\Bean\Annotation\Mapping\Bean;
use MSwoft\Validator\Annotation\Mapping\Mobile;
use MSwoft\Validator\Contract\RuleInterface;
use MSwoft\Validator\Exception\ValidatorException;
use MSwoft\Validator\Helper\ValidatorHelper;

/**
 * Class MobileRule
 *
 * @since 2.0
 *
 * @Bean(Mobile::class)
 */
class MobileRule implements RuleInterface
{
    /**
     * @param array      $data
     * @param string     $propertyName
     * @param object     $item
     * @param mixed|null $default
     *
     * @return array
     * @throws ValidatorException
     */
    public function validate(array $data, string $propertyName, $item, $default = null, $strict = false): array
    {
        /* @var Mobile $item */
        $value = $data[$propertyName];
        if (ValidatorHelper::validateMobile($value)) {
            return $data;
        }

        $message = $item->getMessage();
        $message = (empty($message)) ? sprintf('%s is invalid mobile!', $propertyName) : $message;
        throw new ValidatorException($message);
    }
}
