<?php declare(strict_types=1);


namespace MSwoft\Validator\Rule;


use MSwoft\Bean\Annotation\Mapping\Bean;
use MSwoft\Validator\Annotation\Mapping\Min;
use MSwoft\Validator\Contract\RuleInterface;
use MSwoft\Validator\Exception\ValidatorException;

/**
 * Class MinRule
 *
 * @since 2.0
 *
 * @Bean(Min::class)
 */
class MinRule implements RuleInterface
{
    /**
     * @param array      $data
     * @param string     $propertyName
     * @param object     $item
     * @param mixed|null $default
     *
     * @return array
     * @throws ValidatorException
     */
    public function validate(array $data, string $propertyName, $item, $default = null, $strict = false): array
    {
        /* @var Min $item */
        $min   = $item->getValue();
        $value = $data[$propertyName];
        if ($value >= $min) {
            return $data;
        }

        $message = $item->getMessage();
        $message = (empty($message)) ? sprintf('%s is too small(min=%d)', $propertyName, $min) : $message;

        throw new ValidatorException($message);
    }
}
