<?php declare(strict_types=1);

namespace MSwoft\Validator\Rule;

use MSwoft\Bean\Annotation\Mapping\Bean;
use MSwoft\Validator\Annotation\Mapping\Low;
use MSwoft\Validator\Contract\RuleInterface;
use MSwoft\Validator\Exception\ValidatorException;

/**
 * Class LowRule
 *
 * @since 2.0
 *
 * @Bean(Low::class)
 */
class LowRule implements RuleInterface
{
    /**
     * @param array  $data
     * @param string $propertyName
     * @param object $item
     * @param null   $default
     *
     * @return array
     * @throws ValidatorException
     */
    public function validate(array $data, string $propertyName, $item, $default = null, $strict = false): array
    {
        $value = $data[$propertyName];
        $rule  = '/^[a-z]+$/';
        if (preg_match($rule, $value)) {
            return $data;
        }

        /* @var Low $item */
        $message = $item->getMessage();
        $message = (empty($message)) ? sprintf('%s must be lowercase alpha', $propertyName) : $message;

        throw new ValidatorException($message);
    }
}
