<?php declare(strict_types=1);


namespace MSwoft\Validator\Rule;


use MSwoft\Bean\Annotation\Mapping\Bean;
use MSwoft\Validator\Annotation\Mapping\Ip;
use MSwoft\Validator\Contract\RuleInterface;
use MSwoft\Validator\Exception\ValidatorException;
use MSwoft\Validator\Helper\ValidatorHelper;

/**
 * Class IpRule
 *
 * @since 2.0
 *
 * @Bean(Ip::class)
 */
class IpRule implements RuleInterface
{
    /**
     * @param array      $data
     * @param string     $propertyName
     * @param object     $item
     * @param mixed|null $default
     *
     * @return array
     * @throws ValidatorException
     */
    public function validate(array $data, string $propertyName, $item, $default = null, $strict = false): array
    {
        $value = $data[$propertyName];
        if (ValidatorHelper::validateIp($value)) {
            return $data;
        }

        /* @var Ip $item */
        $message = $item->getMessage();
        $message = (empty($message)) ? sprintf('%s is invalid ip', $propertyName) : $message;

        throw new ValidatorException($message);
    }
}
