<?php declare(strict_types=1);

namespace MSwoft\Validator\Rule;

use MSwoft\Bean\Annotation\Mapping\Bean;
use MSwoft\Context\Context;
use MSwoft\Http\Message\Upload\UploadedFile;
use MSwoft\Validator\Annotation\Mapping\FileSuffix;
use MSwoft\Validator\Contract\RuleInterface;
use MSwoft\Validator\Exception\ValidatorException;

/**
 * Class FileSuffixRule
 *
 * @since 2.0
 *
 * @Bean(FileSuffix::class)
 */
class FileSuffixRule implements RuleInterface
{
    /**
     * @param array  $data
     * @param string $propertyName
     * @param object $item
     * @param null   $default
     *
     * @return array
     * @throws ValidatorException
     */
    public function validate(array $data, string $propertyName, $item, $default = null, $strict = false): array
    {
        /* @var FileSuffix $item */
        $values     = $item->getSuffix();
        $message    = $item->getMessage();
        $message    = (empty($message)) ? sprintf('%s file suffix name must be in ', $propertyName) : $message;
        $files      = Context::mustGet()->getRequest()->getUploadedFiles();
        $suffixName = function ($file) {
            return pathinfo($file, PATHINFO_EXTENSION);
        };
        foreach ($files as $key => $field) {
            if ($key !== $propertyName) {
                continue;
            }
            if (!is_array($field)) {
                /* @var UploadedFile $field */
                if (!in_array(strtolower($suffixName($field->getClientFilename())), $values)) {
                    throw new ValidatorException($message);
                }
            } else {
                foreach ($field as $file) {
                    /* @var UploadedFile $file */
                    if (!in_array(strtolower($suffixName($file->getClientFilename())), $values)) {
                        throw new ValidatorException($message);
                    }
                }
            }
        }
        return $data;
    }
}
