<?php declare(strict_types=1);

namespace MSwoft\Validator\Rule;

use MSwoft\Bean\Annotation\Mapping\Bean;
use MSwoft\Context\Context;
use MSwoft\Http\Message\Upload\UploadedFile;
use MSwoft\Validator\Annotation\Mapping\FileMediaType;
use MSwoft\Validator\Contract\RuleInterface;
use MSwoft\Validator\Exception\ValidatorException;

/**
 * Class FileMediaTypeRule
 *
 * @since 2.0
 *
 * @Bean(FileMediaType::class)
 */
class FileMediaTypeRule implements RuleInterface
{
    /**
     * @param array  $data
     * @param string $propertyName
     * @param object $item
     * @param null   $default
     *
     * @return array
     * @throws ValidatorException
     */
    public function validate(array $data, string $propertyName, $item, $default = null, $strict = false): array
    {
        /* @var FileMediaType $item */
        $values  = $item->getMediaType();
        $message = $item->getMessage();
        $message = (empty($message)) ? sprintf('%s file media type must be  exists in media type', $propertyName) :
            $message;
        $files   = Context::mustGet()->getRequest()->getUploadedFiles();
        foreach ($files as $key => $field) {
            if ($key !== $propertyName) {
                continue;
            }
            if (!is_array($field)) {
                /* @var UploadedFile $field */

                if (!in_array($field->getClientMediaType(), $values)) {

                    throw new ValidatorException($message);
                }
            } else {
                foreach ($field as $file) {
                    /* @var UploadedFile $field */
                    if (!in_array($file->getClientMediaType(), $values)) {
                        throw new ValidatorException($message);
                    }
                }
            }
        }
        return $data;
    }
}
