<?php declare(strict_types=1);

namespace MSwoft\Validator\Rule;

use MSwoft\Bean\Annotation\Mapping\Bean;
use MSwoft\Validator\Annotation\Mapping\Dns;
use MSwoft\Validator\Contract\RuleInterface;
use MSwoft\Validator\Exception\ValidatorException;

/**
 * Class DnsRule
 *
 * @since 2.0
 *
 * @Bean(Dns::class)
 */
class DnsRule implements RuleInterface
{
    /**
     * @param array  $data
     * @param string $propertyName
     * @param object $item
     * @param null   $default
     *
     * @return array
     * @throws ValidatorException
     */
    public function validate(array $data, string $propertyName, $item, $default = null, $strict = false): array
    {
        $value = $data[$propertyName];

        /* @var Dns $item */
        $message = $item->getMessage();
        if (empty($value)) {
            $message = (empty($message)) ? sprintf('%s can not be empty!', $propertyName) : $message;
            throw new ValidatorException($message);
        }
        if (checkdnsrr($value)) {
            return $data;
        }
        $message = (empty($message)) ? sprintf('%s invalid dns', $propertyName) : $message;

        throw new ValidatorException($message);
    }
}
