<?php declare(strict_types=1);


namespace MSwoft\Validator\Listener;


use MSwoft\Event\Annotation\Mapping\Listener;
use MSwoft\Event\EventHandlerInterface;
use MSwoft\Event\EventInterface;
use MSwoft\SwoftEvent;
use MSwoft\Validator\Exception\ValidatorException;
use MSwoft\Validator\ValidatorRegister;

/**
 * Class AppInitCompleteListener
 *
 * @since 2.0
 *
 * @Listener(event=SwoftEvent::APP_INIT_COMPLETE)
 */
class AppInitCompleteListener implements EventHandlerInterface
{
    /**
     * @param EventInterface $event
     *
     * @throws ValidatorException
     */
    public function handle(EventInterface $event): void
    {
        ValidatorRegister::checkValidators();
    }
}