<?php declare(strict_types=1);


namespace MSwoft\Validator\Annotation\Parser;


use ReflectionException;
use MSwoft\Annotation\Annotation\Mapping\AnnotationParser;
use MSwoft\Annotation\Annotation\Parser\Parser;
use MSwoft\Bean\Annotation\Mapping\Bean;
use MSwoft\Validator\Annotation\Mapping\Validator;
use MSwoft\Validator\ValidatorRegister;

/**
 * Class ValidatorParser
 *
 * @since 2.0
 *
 * @AnnotationParser(Validator::class)
 */
class ValidatorParser extends Parser
{
    /**
     * @param int       $type
     * @param Validator $annotationObject
     *
     * @return array
     * @throws ReflectionException
     */
    public function parse(int $type, $annotationObject): array
    {
        $beanName = $this->className;
        $name     = $annotationObject->getName();
        if (!empty($name)) {
            $beanName = $name;
        }

        ValidatorRegister::registerValidator($this->className, $beanName);

        return [$beanName, $this->className, Bean::SINGLETON, ''];
    }
}