<?php declare(strict_types=1);

namespace MSwoft\Validator\Annotation\Parser;

use ReflectionException;
use MSwoft\Annotation\Annotation\Mapping\AnnotationParser;
use MSwoft\Annotation\Annotation\Parser\Parser;
use MSwoft\Validator\Annotation\Mapping\ChsAlphaNum;
use MSwoft\Validator\Exception\ValidatorException;
use MSwoft\Validator\ValidatorRegister;

/**
 * Class AlphaParser
 *
 * @since 2.0
 *
 * @AnnotationParser(annotation=ChsAlphaNum::class)
 */
class ChsAlphaNumParser extends Parser
{
    /**
     * @param int    $type
     * @param object $annotationObject
     *
     * @return array
     * @throws ReflectionException
     * @throws ValidatorException
     */
    public function parse(int $type, $annotationObject): array
    {
        if ($type != self::TYPE_PROPERTY) {
            return [];
        }
        ValidatorRegister::registerValidatorItem($this->className, $this->propertyName, $annotationObject);
        return [];
    }
}
