<?php declare(strict_types=1);

namespace MSwoft\Task\Swoole;

use MSwoft\Bean\Annotation\Mapping\Bean;
use MSwoft\Bean\BeanFactory;
use MSwoft\Server\Contract\TaskInterface;
use MSwoft\Task\Exception\TaskException;
use MSwoft\Task\Request;
use MSwoft\Task\Response;
use MSwoft\Task\TaskDispatcher;
use Swoole\Server;
use Swoole\Server\Task as SwooleTask;

/**
 * Class TaskListener
 *
 * @since 2.0
 *
 * @Bean()
 */
class TaskListener implements TaskInterface
{
    /**
     * @param Server     $server
     * @param SwooleTask $task
     *
     * @throws TaskException
     */
    public function onTask(Server $server, SwooleTask $task): void
    {
        $request  = Request::new($server, $task);
        $response = Response::new($task);

        /* @var TaskDispatcher $dispatcher */
        $dispatcher = BeanFactory::getBean('taskDispatcher');
        $dispatcher->dispatch($request, $response);
    }
}
