<?php declare(strict_types=1);

namespace MSwoft\Task\Listener;

use MSwoft\Context\Context;
use MSwoft\Event\Annotation\Mapping\Listener;
use MSwoft\Event\EventHandlerInterface;
use MSwoft\Event\EventInterface;
use MSwoft\Log\Helper\Log;
use MSwoft\Server\SwooleEvent;
use MSwoft\Task\Request;
use MSwoft\Task\Response;
use MSwoft\Task\TaskContext;
use MSwoft\Task\TaskEvent;

/**
 * Class BeforeTaskListener
 *
 * @since 2.0
 *
 * @Listener(event=TaskEvent::BEFORE_TASK)
 */
class BeforeTaskListener implements EventHandlerInterface
{
    /**
     * @param EventInterface $event
     *
     */
    public function handle(EventInterface $event): void
    {
        /**
         * @var Request  $request
         * @var Response $response
         */
        [$request, $response] = $event->getParams();

        $context = TaskContext::new($request, $response);

        if (Log::getLogger()->isEnable()) {
            $uri  = sprintf('%s::%s', $request->getName(), $request->getMethod());
            $data = [
                'event'       => SwooleEvent::TASK,
                'uri'         => $uri,
                'requestTime' => microtime(true),
            ];
            $context->setMulti($data);
        }

        Context::set($context);
    }
}
