<?php declare(strict_types=1);


namespace MSwoft\Task\Listener;


use MSwoft\Context\Context;
use MSwoft\Event\Annotation\Mapping\Listener;
use MSwoft\Event\EventHandlerInterface;
use MSwoft\Event\EventInterface;
use MSwoft\Log\Helper\Log;
use MSwoft\Server\SwooleEvent;
use MSwoft\Task\FinishContext;
use MSwoft\Task\TaskEvent;

/**
 * Class BeforeFinishListener
 *
 * @since 2.0
 *
 * @Listener(TaskEvent::BEFORE_FINISH)
 */
class BeforeFinishListener implements EventHandlerInterface
{
    /**
     * @param EventInterface $event
     *
     */
    public function handle(EventInterface $event): void
    {
        list($server, $taskId, $data) = $event->getParams();

        $context = FinishContext::new($server, $taskId, $data);

        if (Log::getLogger()->isEnable()) {
            $data = [
                'event'       => SwooleEvent::FINISH,
                'uri'         => $context->getTaskUniqid(),
                'requestTime' => microtime(true),
            ];
            $context->setMulti($data);
        }

        Context::set($context);
    }
}
