<?php declare(strict_types=1);


namespace MSwoft\Task\Listener;


use MSwoft\Bean\BeanFactory;
use MSwoft\Event\Annotation\Mapping\Listener;
use MSwoft\Event\EventHandlerInterface;
use MSwoft\Event\EventInterface;
use MSwoft\SwoftEvent;
use MSwoft\Task\Router\Router;
use MSwoft\Task\Router\RouteRegister;

/**
 * Class AppInitCompleteListener
 *
 * @since 2.0
 *
 * @Listener(event=SwoftEvent::APP_INIT_COMPLETE)
 */
class AppInitCompleteListener implements EventHandlerInterface
{
    /**
     * @param EventInterface $event
     *
     */
    public function handle(EventInterface $event): void
    {
        /* @var Router $router */
        $router = BeanFactory::getBean('taskRouter');

        RouteRegister::registerRoutes($router);
    }
}