<?php declare(strict_types=1);


namespace MSwoft\Task\Listener;


use Swoft;
use MSwoft\Event\Annotation\Mapping\Listener;
use MSwoft\Event\EventHandlerInterface;
use MSwoft\Event\EventInterface;
use MSwoft\SwoftEvent;
use MSwoft\Task\Response;
use MSwoft\Task\TaskEvent;

/**
 * Class AfterTaskListener
 *
 * @since 2.0
 *
 * @Listener(event=TaskEvent::AFTER_TASK)
 */
class AfterTaskListener implements EventHandlerInterface
{
    /**
     * @param EventInterface $event
     *
     */
    public function handle(EventInterface $event): void
    {
        /* @var Response $response */
        $response = $event->getParam(0);
        $response->send();

        // Defer
        Swoft::trigger(SwoftEvent::COROUTINE_DEFER);
        // Destroy
        Swoft::trigger(SwoftEvent::COROUTINE_COMPLETE);
    }
}