<?php declare(strict_types=1);


namespace MSwoft\Task\Listener;


use Swoft;
use MSwoft\Event\Annotation\Mapping\Listener;
use MSwoft\Event\EventHandlerInterface;
use MSwoft\Event\EventInterface;
use MSwoft\SwoftEvent;
use MSwoft\Task\TaskEvent;

/**
 * Class AfterFinishListener
 *
 * @since 2.0
 *
 * @Listener(event=TaskEvent::AFTER_FINISH)
 */
class AfterFinishListener implements EventHandlerInterface
{
    /**
     * @param EventInterface $event
     *
     */
    public function handle(EventInterface $event): void
    {
        // Defer
        Swoft::trigger(SwoftEvent::COROUTINE_DEFER);

        // Destroy
        Swoft::trigger(SwoftEvent::COROUTINE_COMPLETE);
    }
}