<?php declare(strict_types=1);


namespace MSwoft\Task;


use MSwoft\Bean\Annotation\Mapping\Bean;
use MSwoft\Bean\Concern\PrototypeTrait;
use MSwoft\Context\AbstractContext;
use Swoole\Server;

/**
 * Class FinishContext
 *
 * @since 2.0
 *
 * @Bean(scope=Bean::PROTOTYPE)
 */
class FinishContext extends AbstractContext
{
    use PrototypeTrait;

    /**
     * @var Server
     */
    private $server;

    /**
     * @var int
     */
    private $taskId;

    /**
     * @var string
     */
    private $taskData;

    /**
     * Task unique id
     *
     * @var string
     */
    private $taskUniqid = '';

    /**
     * @param Server $server
     * @param int    $taskId
     * @param string $data
     *
     * @return FinishContext
     */
    public static function new(Server $server, int $taskId, string $data): self
    {
        $instance = self::__instance();

        $instance->server     = $server;
        $instance->taskData   = $data;
        $instance->taskId     = $taskId;
        $instance->taskUniqid = Task::getUniqId($taskId);

        return $instance;
    }

    /**
     * @return Server
     */
    public function getServer(): Server
    {
        return $this->server;
    }

    /**
     * @return int
     */
    public function getTaskId(): int
    {
        return $this->taskId;
    }

    /**
     * @return string
     */
    public function getTaskData(): string
    {
        return $this->taskData;
    }

    /**
     * @return string
     */
    public function getTaskUniqid(): string
    {
        return $this->taskUniqid;
    }
}
