<?php declare(strict_types=1);


namespace MSwoft\Task\Annotation\Parser;


use MSwoft\Annotation\Annotation\Mapping\AnnotationParser;
use MSwoft\Annotation\Annotation\Parser\Parser;
use MSwoft\Bean\Annotation\Mapping\Bean;
use MSwoft\Task\Annotation\Mapping\Task;
use MSwoft\Task\Router\RouteRegister;

/**
 * Class TaskParser
 *
 * @since 2.0
 *
 * @AnnotationParser(annotation=Task::class)
 */
class TaskParser extends Parser
{
    /**
     * @param int  $type
     * @param Task $annotationObject
     *
     * @return array
     */
    public function parse(int $type, $annotationObject): array
    {
        RouteRegister::registerByClassName($this->className, $annotationObject->getName());

        return [$this->className, $this->className, Bean::SINGLETON, ''];
    }
}