<?php declare(strict_types=1);


namespace MSwoft\Task\Annotation\Parser;


use MSwoft\Annotation\Annotation\Mapping\AnnotationParser;
use MSwoft\Annotation\Annotation\Parser\Parser;
use MSwoft\Task\Annotation\Mapping\TaskMapping;
use MSwoft\Task\Router\RouteRegister;

/**
 * Class TaskMappingParser
 *
 * @since 2.0
 *
 * @AnnotationParser(TaskMapping::class)
 */
class TaskMappingParser extends Parser
{
    /**
     * @param int         $type
     * @param TaskMapping $annotationObject
     *
     * @return array
     */
    public function parse(int $type, $annotationObject): array
    {
        RouteRegister::registerByMethodName($this->className, $this->methodName, $annotationObject->getName());

        return [];
    }
}