<?php declare(strict_types=1);


namespace MSwoft\Server\Listener;


use MSwoft\Context\Context;
use MSwoft\Event\Annotation\Mapping\Listener;
use MSwoft\Event\EventHandlerInterface;
use MSwoft\Event\EventInterface;
use MSwoft\Log\Helper\Log;
use MSwoft\Server\Context\WorkerStartContext;
use MSwoft\Server\ServerEvent;
use MSwoft\Server\SwooleEvent;

/**
 * Class BeforeWorkerStartListener
 *
 * @since 2.0
 *
 * @Listener(event=ServerEvent::BEFORE_WORKER_START_EVENT)
 */
class BeforeWorkerStartListener implements EventHandlerInterface
{
    /**
     * @param EventInterface $event
     */
    public function handle(EventInterface $event): void
    {
        [$server, $workerId] = $event->getParams();
        $context = WorkerStartContext::new($server, $workerId);

        if (Log::getLogger()->isEnable()) {
            $data = [
                'event'       => SwooleEvent::WORKER_START,
                'uri'         => (string)$workerId,
                'requestTime' => microtime(true),
            ];
            $context->setMulti($data);
        }

        Context::set($context);
    }
}
