<?php declare(strict_types=1);


namespace MSwoft\Server\Listener;


use MSwoft\Context\Context;
use MSwoft\Event\Annotation\Mapping\Listener;
use MSwoft\Event\EventHandlerInterface;
use MSwoft\Event\EventInterface;
use MSwoft\Log\Helper\Log;
use MSwoft\Server\Context\WorkerErrorContext;
use MSwoft\Server\ServerEvent;
use MSwoft\Server\SwooleEvent;

/**
 * Class BeforeWorkerErrorListener
 *
 * @since 2.0
 *
 * @Listener(event=ServerEvent::BEFORE_WORKER_ERROR_EVENT)
 */
class BeforeWorkerErrorListener implements EventHandlerInterface
{
    /**
     * @param EventInterface $event
     */
    public function handle(EventInterface $event): void
    {
        [$server, $workerId, $workerPid, $exitCode, $signal] = $event->getParams();

        $context = WorkerErrorContext::new($server, $workerId, $workerPid, $exitCode, $signal);
        if (Log::getLogger()->isEnable()) {
            $data = [
                'event'       => SwooleEvent::WORKER_ERROR,
                'uri'         => (string)$workerId,
                'requestTime' => microtime(true),
            ];
            $context->setMulti($data);
        }

        Context::set($context);
    }
}
