<?php declare(strict_types=1);

namespace MSwoft\Server\Listener;

use MSwoft\Context\Context;
use MSwoft\Event\Annotation\Mapping\Listener;
use MSwoft\Event\EventHandlerInterface;
use MSwoft\Event\EventInterface;
use MSwoft\Log\Helper\Log;
use MSwoft\Server\Context\StartContext;
use MSwoft\Server\ServerEvent;
use MSwoft\Server\SwooleEvent;

/**
 * Class BeforeStartEventListener
 *
 * @since 2.0
 *
 * @Listener(event=ServerEvent::BEFORE_START_EVENT)
 */
class BeforeStartEventListener implements EventHandlerInterface
{
    /**
     * @param EventInterface $event
     */
    public function handle(EventInterface $event): void
    {
        [$server] = $event->getParams();
        $context = StartContext::new($server);

        if (Log::getLogger()->isEnable()) {
            $data = [
                'event'       => SwooleEvent::START,
                'uri'         => '',
                'requestTime' => microtime(true),
            ];
            $context->setMulti($data);
        }

        Context::set($context);
    }
}
