<?php declare(strict_types=1);

namespace MSwoft\Server\Listener;

use MSwoft\Context\Context;
use MSwoft\Event\Annotation\Mapping\Listener;
use MSwoft\Event\EventHandlerInterface;
use MSwoft\Event\EventInterface;
use MSwoft\Log\Helper\Log;
use MSwoft\Server\Context\ShutdownContext;
use MSwoft\Server\ServerEvent;
use MSwoft\Server\SwooleEvent;

/**
 * Class BeforeShutdownEventListener
 *
 * @since 2.0
 *
 * @Listener(event=ServerEvent::BEFORE_SHUTDOWN_EVENT)
 */
class BeforeShutdownEventListener implements EventHandlerInterface
{
    /**
     * @param EventInterface $event
     */
    public function handle(EventInterface $event): void
    {
        [$server] = $event->getParams();
        $context = ShutdownContext::new($server);

        if (Log::getLogger()->isEnable()) {
            $data = [
                'event'       => SwooleEvent::SHUTDOWN,
                'uri'         => '',
                'requestTime' => microtime(true),
            ];
            $context->setMulti($data);
        }

        Context::set($context);
    }
}
