<?php declare(strict_types=1);

namespace MSwoft\Server\Listener;

use Swoft;
use MSwoft\Event\Annotation\Mapping\Listener;
use MSwoft\Event\EventHandlerInterface;
use MSwoft\Event\EventInterface;
use MSwoft\Server\ServerEvent;
use MSwoft\SwoftEvent;

/**
 * Class AfterListener
 *
 * @since 2.0
 *
 * @Listener(event=ServerEvent::AFTER_EVENT)
 */
class AfterListener implements EventHandlerInterface
{
    /**
     * @param EventInterface $event
     */
    public function handle(EventInterface $event): void
    {
        // Defer
        Swoft::trigger(SwoftEvent::COROUTINE_DEFER);

        // Destroy
        Swoft::trigger(SwoftEvent::COROUTINE_COMPLETE);
    }
}
