<?php declare(strict_types=1);

namespace MSwoft\Rpc\Client;

use MSwoft\Proxy\Exception\ProxyException;
use MSwoft\Proxy\Proxy as BaseProxy;
use MSwoft\Rpc\Client\Exception\RpcClientException;
use MSwoft\Rpc\Client\Proxy\Ast\ProxyVisitor;
use MSwoft\Stdlib\Helper\Str;
use function interface_exists;
use function sprintf;

/**
 * Class Proxy
 *
 * @since 2.0
 */
class Proxy
{
    /**
     * @param string $className
     *
     * @return string
     * @throws RpcClientException
     * @throws ProxyException
     */
    public static function newClassName(string $className): string
    {
        if (!interface_exists($className)) {
            throw new RpcClientException('`@var` for `@Reference` must be exist interface!');
        }

        $proxyId = sprintf('IGNORE_%s', Str::getUniqid());
        $visitor = new ProxyVisitor($proxyId);

        return BaseProxy::newClassName($className, $visitor);
    }
}
