<?php declare(strict_types=1);

namespace MSwoft\Rpc\Client;

use MSwoft\Connection\Pool\AbstractPool;
use MSwoft\Connection\Pool\Contract\ConnectionInterface;
use MSwoft\Rpc\Client\Exception\RpcClientException;

/**
 * Class Pool
 *
 * @since 2.0
 */
class Pool extends AbstractPool
{
    /**
     * @var Client
     */
    protected $client;

    /**
     * @return ConnectionInterface
     * @throws RpcClientException
     */
    public function createConnection(): ConnectionInterface
    {
        if (empty($this->client)) {
            throw new RpcClientException(sprintf('Pool(%s) client can not be null!', __CLASS__));
        }

        return $this->client->createConnection($this);
    }
}
