<?php declare(strict_types=1);

namespace MSwoft\Rpc\Client\Listener;

use MSwoft\Bean\BeanFactory;
use MSwoft\Event\Annotation\Mapping\Subscriber;
use MSwoft\Event\EventInterface;
use MSwoft\Event\EventSubscriberInterface;
use MSwoft\Log\Helper\CLog;
use MSwoft\Rpc\Client\Pool;
use MSwoft\Server\SwooleEvent;
use MSwoft\SwoftEvent;

/**
 * Class WorkerStopAndErrorListener
 *
 * @since 2.0
 *
 * @Subscriber()
 */
class WorkerStopAndErrorListener implements EventSubscriberInterface
{
    /**
     * @return array
     */
    public static function getSubscribedEvents(): array
    {
        return [
            SwooleEvent::WORKER_STOP    => 'handle',
            SwoftEvent::WORKER_SHUTDOWN => 'handle',
        ];
    }

    /**
     * @param EventInterface $event
     *
     */
    public function handle(EventInterface $event): void
    {
        $pools = BeanFactory::getBeans(Pool::class);

        /* @var Pool $pool */
        foreach ($pools as $pool) {
            $count = $pool->close();

            CLog::info('Close %d rpc client connection on %s!', $count, $event->getName());
        }
    }
}
