<?php declare(strict_types=1);


namespace MSwoft\Rpc\Client\Listener;

use MSwoft\Bean\BeanFactory;
use MSwoft\Connection\Pool\Exception\ConnectionPoolException;
use MSwoft\Event\Annotation\Mapping\Listener;
use MSwoft\Event\EventHandlerInterface;
use MSwoft\Event\EventInterface;
use MSwoft\Rpc\Client\Pool;
use MSwoft\Server\ServerEvent;

/**
 * Class WorkerStartListener
 *
 * @since 2.0
 *
 * @Listener(event=ServerEvent::WORK_PROCESS_START)
 */
class WorkerStartListener implements EventHandlerInterface
{
    /**
     * @param EventInterface $event
     *
     * @throws ConnectionPoolException
     */
    public function handle(EventInterface $event): void
    {
        $pools = BeanFactory::getBeans(Pool::class);

        /* @var Pool $pool */
        foreach ($pools as $pool) {
            $pool->initPool();
        }
    }
}