<?php

namespace MSwoft\Http\Server\Swoole;

use MSwoft\Bean\Annotation\Mapping\Bean;
use MSwoft\Bean\Annotation\Mapping\Inject;
use MSwoft\Exception\SwoftException;
use MSwoft\Http\Message\Request as ServerRequest;
use MSwoft\Http\Message\Response as ServerResponse;
use MSwoft\Http\Server\HttpDispatcher;
use MSwoft\Server\Contract\RequestInterface;
use Swoole\Http\Request;
use Swoole\Http\Response;

/**
 * Class RequestListener
 *
 * @Bean()
 *
 * @since 2.0
 */
class RequestListener implements RequestInterface
{
    /**
     * @Inject()
     *
     * @var HttpDispatcher
     */
    private $dispatcher;

    /**
     * @param Request  $request
     * @param Response $response
     *
     * @throws SwoftException
     */
    public function onRequest(Request $request, Response $response): void
    {
        $psrRequest  = ServerRequest::new($request);
        $psrResponse = ServerResponse::new($response);

        $this->dispatcher->dispatch($psrRequest, $psrResponse);
    }
}
