<?php declare(strict_types=1);

namespace MSwoft\Http\Server\Parser;

use MSwoft\Bean\Annotation\Mapping\Bean;
use MSwoft\Http\Message\Contract\RequestParserInterface;
use MSwoft\Http\Server\Exception\HttpServerException;
use MSwoft\Stdlib\Helper\JsonHelper;
use Throwable;

/**
 * Class JsonRequestParser
 *
 * @Bean()
 *
 * @since 2.0
 */
class JsonRequestParser implements RequestParserInterface
{
    /**
     * @param string $content
     *
     * @return mixed
     * @throws HttpServerException
     */
    public function parse(string $content)
    {
        try {
            $parsedBody = JsonHelper::decode($content, true);
        } catch (Throwable $e) {
            throw new HttpServerException(
                sprintf('Request body parse to json error(%s), body=%s', $e->getMessage(), $content)
            );
        }

        return $parsedBody;
    }
}
