<?php declare(strict_types=1);

namespace MSwoft\Http\Server\Middleware;

use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;
use Psr\Http\Server\RequestHandlerInterface;
use MSwoft\Bean\Annotation\Mapping\Bean;
use MSwoft\Http\Message\Request;
use MSwoft\Http\Server\Contract\MiddlewareInterface;
use MSwoft\Http\Server\Exception\HttpServerException;
use MSwoft\Http\Server\RequestHandler;
use MSwoft\Http\Server\Router\Route;
use MSwoft\Http\Server\Router\Router;
use function explode;

/**
 * Class UserMiddleware
 *
 * @Bean()
 *
 * @since 2.0
 */
class UserMiddleware implements MiddlewareInterface
{
    /**
     * @param ServerRequestInterface  $request
     * @param RequestHandlerInterface $handler
     *
     * @return ResponseInterface
     * @throws HttpServerException
     */
    public function process(ServerRequestInterface $request, RequestHandlerInterface $handler): ResponseInterface
    {
        // Route data
        $routeData = $request->getAttribute(Request::ROUTER_ATTRIBUTE);

        /* @var Route $route */
        [$status, , $route] = $routeData;

        if ($status !== Router::FOUND) {
            return $handler->handle($request);
        }

        // Controller and method
        $handlerId = $route->getHandler();
        [$className, $method] = explode('@', $handlerId);

        $middlewares = MiddlewareRegister::getMiddlewares($className, $method);
        if (!empty($middlewares) && $handler instanceof RequestHandler) {
            $handler->insertMiddlewares($middlewares);
        }

        return $handler->handle($request);
    }
}
