<?php declare(strict_types=1);
/**
 * This file is part of Swoft.
 *
 * @link     https://swoft.org
 * @document https://swoft.org/docs
 * @contact  group@swoft.org
 * @license  https://github.com/swoft-cloud/swoft/blob/master/LICENSE
 */

namespace MSwoft\Http\Server\Middleware\Api;

use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;
use Psr\Http\Server\RequestHandlerInterface;
use MSwoft\Bean\Annotation\Mapping\Bean;
use MSwoft\Exception\SwoftException;
use MSwoft\Http\Message\Request;
use MSwoft\Http\Message\Response;
use MSwoft\Http\Server\Contract\MiddlewareInterface;

use function context;

/**
 * Class FavIconMiddleware
 *
 * @Bean("ResponseFormatMiddleware")
 */
class ResponseFormatMiddleware implements MiddlewareInterface
{
    /**
     * Process an incoming server request.
     *
     * @param ServerRequestInterface|Request $request
     * @param RequestHandlerInterface        $handler
     *
     * @return ResponseInterface
     * @inheritdoc
     * @throws SwoftException
     */
    public function process(ServerRequestInterface $request, RequestHandlerInterface $handler): ResponseInterface
    {
        /** @var Response $response */
        $response = $handler->handle($request);

        return $response->withData(
            $this->format($response->getData())
        );
    }

    /**
     * 格式化输出内容
     * @param        $data
     * @param int    $code
     * @param string $message
     * @return array
     */
    public function format($data, $code = 0, $message = ''): array
    {
        $result = [
            'code' => (int)$code
        ];
        if (!is_null($data)) $result['data'] = $data;
        if (!empty($message)) $result['message'] = $message;

        return $result;
    }
}
