<?php declare(strict_types=1);

namespace MSwoft\Http\Server\Middleware\Api;

use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;
use Psr\Http\Server\RequestHandlerInterface;
use MSwoft\Bean\Annotation\Mapping\Bean;
use MSwoft\Http\Server\Contract\MiddlewareInterface;

/**
 * @Bean("CorsMiddleware")
 */
class CorsMiddleware implements MiddlewareInterface
{
  /**
   * Process an incoming server request.
   * @param ServerRequestInterface $request
   * @param RequestHandlerInterface $handler
   * @return ResponseInterface
   * @inheritdoc
   */
  public function process(ServerRequestInterface $request, RequestHandlerInterface $handler): ResponseInterface
  {
    if ('OPTIONS' === $request->getMethod()) {
      return $this->corsResponse(context()->getResponse());
    }

    if (strpos($request->getUri()->getPath(), 'favicon') !== false) {
      return $this->corsResponse(context()->getResponse());
    }

    return $this->corsResponse($handler->handle($request));
  }

  /**
   * Cors config
   * @param ResponseInterface $response
   * @return ResponseInterface
   */
  public function corsResponse(ResponseInterface $response): ResponseInterface
  {
    $request = context()->getRequest();
    $origin  = $request->getHeaderLine('origin');

    return $response
      ->withHeader('Access-Control-Allow-Origin', $origin)
      ->withHeader('Access-Control-Allow-Credentials', 'true')
      ->withHeader('Access-Control-Allow-Headers', $request->getHeaderLine('Access-Control-Request-Headers'))
      ->withHeader('Access-Control-Allow-Methods', 'GET, POST, PUT, DELETE, PATCH, OPTIONS');
  }
}