<?php

namespace MSwoft\Http\Server\Listener;

use MSwoft\Event\Annotation\Mapping\Listener;
use MSwoft\Event\EventHandlerInterface;
use MSwoft\Event\EventInterface;
use MSwoft\Http\Server\Exception\HttpServerException;
use MSwoft\Http\Server\Middleware\MiddlewareRegister;
use MSwoft\Http\Server\Router\Router;
use MSwoft\Http\Server\Router\RouteRegister;
use MSwoft\SwoftEvent;
use function bean;

/**
 * Class AppInitCompleteListener
 * @since 2.0
 *
 * @Listener(SwoftEvent::APP_INIT_COMPLETE)
 */
class AppInitCompleteListener implements EventHandlerInterface
{
    /**
     * @param EventInterface $event
     *
     * @throws HttpServerException
     */
    public function handle(EventInterface $event): void
    {
        /** @var Router $router Register HTTP routes */
        $router = bean('httpRouter');

        RouteRegister::registerRoutes($router);

        // Register middleware
        MiddlewareRegister::register();
    }
}
