<?php declare(strict_types=1);

namespace MSwoft\Http\Server;

use Swoft;
use MSwoft\Bean\Annotation\Mapping\Bean;
use MSwoft\Error\ErrorManager;
use MSwoft\Error\ErrorType;
use MSwoft\Http\Message\Response;
use MSwoft\Http\Server\Contract\HttpErrorHandlerInterface;
use MSwoft\Log\Helper\CLog;
use MSwoft\Stdlib\Helper\PhpHelper;
use Throwable;
use const APP_DEBUG;

/**
 * Class HttpErrorHandler
 *
 * @since 2.0
 *
 * @Bean()
 */
class HttpErrorDispatcher
{
    /**
     * @param Throwable $e
     * @param Response   $response
     *
     * @return Response
     */
    public function run(Throwable $e, Response $response): Response
    {
        /** @var ErrorManager $handlers */
        $handlers = Swoft::getSingleton(ErrorManager::class);

        /** @var HttpErrorHandlerInterface $handler */
        if ($handler = $handlers->match($e, ErrorType::HTTP)) {
            return $handler->handle($e, $response);
        }

        // Print log to console
        CLog::error(PhpHelper::exceptionToString($e, 'Http Error', APP_DEBUG > 0));

        return $response->withStatus(500)->withContent($e->getMessage());
    }
}
