<?php declare(strict_types=1);

namespace MSwoft\Http\Server;

use MSwoft\Bean\Annotation\Mapping\Bean;
use MSwoft\Bean\Concern\PrototypeTrait;
use MSwoft\Context\AbstractContext;
use MSwoft\Http\Message\Request;
use MSwoft\Http\Message\Response;

/**
 * Class HttpContext
 *
 * @since 2.0
 *
 * @Bean(scope=Bean::PROTOTYPE)
 */
class HttpContext extends AbstractContext
{
    use PrototypeTrait;

    /**
     * @var Request
     */
    protected $request;

    /**
     * @var Response
     */
    protected $response;

    /**
     * Create context replace of construct
     *
     * @param Request  $request
     * @param Response $response
     *
     * @return HttpContext
     */
    public static function new(Request $request, Response $response): self
    {
        $instance = self::__instance();

        $instance->request  = $request;
        $instance->response = $response;

        return $instance;
    }

    /**
     * @param Request $request
     */
    public function setRequest(Request $request): void
    {
        $this->request = $request;
    }

    /**
     * @return Request
     */
    public function getRequest(): Request
    {
        return $this->request;
    }

    /**
     * @return Response
     */
    public function getResponse(): Response
    {
        return $this->response;
    }

    /**
     * Clear resource
     */
    public function clear(): void
    {
        // Clear data
        parent::clear();

        // Clear request/response
        $this->request = $this->response = null;
    }
}
