<?php declare(strict_types=1);

namespace MSwoft\Http\Server\Formatter;

use MSwoft\Bean\Annotation\Mapping\Bean;
use MSwoft\Http\Message\ContentType;
use MSwoft\Http\Message\Contract\ResponseFormatterInterface;
use MSwoft\Http\Message\Contract\ResponseInterface;
use MSwoft\Http\Message\Response;
use MSwoft\Stdlib\Helper\XmlHelper;

/**
 * Class XmlResponseFormatter
 *
 * @Bean()
 *
 * @since 2.0
 */
class XmlResponseFormatter implements ResponseFormatterInterface
{
    /**
     * @param Response|ResponseInterface $response
     *
     * @return Response
     */
    public function format(Response $response): Response
    {
        $response = $response->withoutHeader(ContentType::KEY)
            ->withAddedHeader(ContentType::KEY, ContentType::XML);

        $data = $response->getData();

        if ($data !== null) {
            $data    = !is_array($data) ? [$data => $data] : $data;
            $content = XmlHelper::encode($data);
            return $response->withContent($content);
        }

        return $response;
    }
}
