<?php declare(strict_types=1);


namespace MSwoft\Http\Server\Exception\Handler;

use MSwoft\Error\Annotation\Mapping\ExceptionHandler;
use MSwoft\Http\Message\Response;
use Throwable;

/**
 * @ExceptionHandler(\Exception::class)
 */
class DefaultExceptionHandler extends AbstractHttpErrorHandler
{
    public function handle(Throwable $e, Response $response): Response
    {
        return bean("CorsMiddleware")->CorsResponse(
            $response->withData(
                bean("ResponseFormatMiddleware")->format(
                    null,
                    $e->getCode(),
                    $e->getMessage()
                )
            )
        );
    }
}