<?php

namespace MSwoft\Http\Server\Annotation\Parser;

use MSwoft\Annotation\Annotation\Mapping\AnnotationParser;
use MSwoft\Annotation\Annotation\Parser\Parser;
use MSwoft\Annotation\Exception\AnnotationException;
use MSwoft\Http\Server\Annotation\Mapping\RequestMapping;
use MSwoft\Http\Server\Router\RouteRegister;

/**
 * Class RequestMappingParser
 *
 * @since 2.0
 *
 * @AnnotationParser(RequestMapping::class)
 */
class RequestMappingParser extends Parser
{
    /**
     * @param int            $type
     * @param RequestMapping $annotation
     *
     * @return array
     * @throws AnnotationException
     */
    public function parse(int $type, $annotation): array
    {
        if ($type !== self::TYPE_METHOD) {
            throw new AnnotationException('`@RequestMapping` must be defined on class method!');
        }

        $routeInfo = [
            'action' => $this->methodName,
            'route'  => $annotation->getRoute(),
            'name'   => $annotation->getName(),
            'method' => $annotation->getMethod(),
            'params' => $annotation->getParams(),
        ];

        // Add route info for controller action
        RouteRegister::addRoute($this->className, $routeInfo);

        return [];
    }
}
