<?php declare(strict_types=1);


namespace MSwoft\Http\Server\Annotation\Parser;


use MSwoft\Annotation\Annotation\Mapping\AnnotationParser;
use MSwoft\Annotation\Annotation\Parser\Parser;
use MSwoft\Http\Server\Annotation\Mapping\Middleware;
use MSwoft\Http\Server\Annotation\Mapping\Middlewares;
use MSwoft\Http\Server\Middleware\MiddlewareRegister;

/**
 * Class MiddlewaresParser
 *
 * @AnnotationParser(Middlewares::class)
 *
 * @since 2.0
 */
class MiddlewaresParser extends Parser
{
    /**
     * Parse middlewares
     *
     * @param int         $type
     * @param Middlewares $annotationObject
     *
     * @return array
     */
    public function parse(int $type, $annotationObject): array
    {
        $middlewares = $annotationObject->getMiddlewares();

        foreach ($middlewares as $middleware) {
            if (!$middleware instanceof Middleware) {
                continue;
            }

            $name = $middleware->getName();
            if ($type === self::TYPE_CLASS) {
                MiddlewareRegister::registerByClassName($name, $this->className);
                continue;
            }

            if ($type === self::TYPE_METHOD) {
                MiddlewareRegister::registerByMethodName($name, $this->className, $this->methodName);
            }
        }

        return [];
    }
}