<?php declare(strict_types=1);


namespace MSwoft\Http\Server\Annotation\Parser;


use MSwoft\Annotation\Annotation\Mapping\AnnotationParser;
use MSwoft\Annotation\Annotation\Parser\Parser;
use MSwoft\Http\Server\Annotation\Mapping\Middleware;
use MSwoft\Http\Server\Middleware\MiddlewareRegister;

/**
 * Class MiddlewareParser
 *
 * @AnnotationParser(Middleware::class)
 *
 * @since 2.0
 */
class MiddlewareParser extends Parser
{
    /**
     * Parse middleware
     *
     * @param int        $type
     * @param Middleware $annotationObject
     *
     * @return array
     */
    public function parse(int $type, $annotationObject): array
    {
        $name = $annotationObject->getName();

        if ($type === self::TYPE_CLASS) {
            MiddlewareRegister::registerByClassName($name, $this->className);
            return [];
        }

        if ($type === self::TYPE_METHOD) {
            MiddlewareRegister::registerByMethodName($name, $this->className, $this->methodName);
            return [];
        }

        return [];
    }
}