<?php

namespace MSwoft\Http\Server\Annotation\Parser;

use MSwoft\Annotation\Annotation\Mapping\AnnotationParser;
use MSwoft\Annotation\Annotation\Parser\Parser;
use MSwoft\Bean\Annotation\Mapping\Bean;
use MSwoft\Http\Server\Annotation\Mapping\Controller;
use MSwoft\Http\Server\Exception\HttpServerException;
use MSwoft\Http\Server\Router\RouteRegister;

/**
 * Class ControllerParser
 *
 * @AnnotationParser(Controller::class)
 *
 * @since 2.0
 */
class ControllerParser extends Parser
{
    /**
     * @param int        $type
     * @param Controller $annotation
     *
     * @return array
     * @throws HttpServerException
     */
    public function parse(int $type, $annotation): array
    {
        if ($type !== self::TYPE_CLASS) {
            throw new HttpServerException('`@Controller` must be defined by class!');
        }

        // add route prefix for controller
        RouteRegister::addPrefix($this->className, $annotation->getPrefix());

        return [$this->className, $this->className, Bean::SINGLETON, ''];
    }
}